﻿using System;


using System.Configuration;


using System.ServiceModel;


using System.ServiceModel.Description;


using Microsoft.ServiceBus;


using Microsoft.ServiceBus.Description;




namespace AzureSample
{



    class Program
    {



        static void Main(string[] args)
        {



            string endPoint = ConfigurationSettings.AppSettings["EndPoint"];



            string userName = ConfigurationSettings.AppSettings["UserName"];



            string password = ConfigurationSettings.AppSettings["Password"];





            Uri uri = new
            Uri(endPoint);





            TransportClientEndpointBehavior userNamePasswordServiceBusCredential = new
            TransportClientEndpointBehavior();


            userNamePasswordServiceBusCredential.CredentialType = TransportClientCredentialType.UserNamePassword;


            userNamePasswordServiceBusCredential.Credentials.UserName.UserName = userName;


            userNamePasswordServiceBusCredential.Credentials.UserName.Password = password;





            ServiceHost host = new
            ServiceHost(typeof(LogService), uri);





            ContractDescription contractDescription = ContractDescription.GetContract(typeof(ILogContract), typeof(LogService));





            ServiceEndpoint serviceEndPoint = new
            ServiceEndpoint(contractDescription);


            serviceEndPoint.Address = new
            EndpointAddress(uri);


            serviceEndPoint.Binding = new
            NetTcpRelayBinding();


            serviceEndPoint.Behaviors.Add(userNamePasswordServiceBusCredential);
            host.Description.Endpoints.Add(serviceEndPoint);
            host.Open();

            Console.WriteLine(String.Format("Listening at: {0}", endPoint));



            Console.WriteLine("Press [Enter] to exit");



            Console.ReadLine();




            host.Close();


        }


    }


}

